<?php

/*
	Idealo, xt:commerce CSV-Modul

	(c) idealo 2012,
	
	Please note that this extension is provided as is and without any warranty. It is recommended to always backup your installation prior to use. Use at your own risk.
	
	Extended by
	
	Christoph Zurek (Idealo Internet GmbH, http://www.idealo.de)
*/






include_once ( DIR_FS_CATALOG . 'export/idealo/idealo_csv_shipping.php' );
include_once ( DIR_FS_CATALOG . 'export/idealo/idealo_csv_payment.php' ); 
include_once ( DIR_FS_CATALOG . 'export/idealo/idealo_csv_universal.php' ); 
include_once ( DIR_FS_CATALOG . 'export/idealo/idealo_csv_definition.php' ); 


define ( 'IDEALO_CAMPAIGN', '?refID=94511215' );

class idealo_csv_tools extends idealo_csv_universal{
	
	public $shipping = array();
	
	public $payment = array();

	private $shippingcomment = '';

	private $campaignSet = false;
	
	private $shop_url = '';
	
	private $image_url ='';

	public function __construct(){

	}

	public function AllNeeded(){
		
		$this->getShipping();

		$this->getPayment();
		
		$this->getUrls();
		
		$this->shippingcomment();
				
		$this->checkCampaign();
		
	}

	
	public function getValueIdealoSetting( $value ){
		
		$value_query = xtc_db_query ( "SELECT `" . $value . "` FROM `idealo_csv_setting`;" );
     	$value_db = xtc_db_fetch_array ( $value_query );
     	
     	return $value_db [ $value ];
     	
	}

	
	 public function getPayment(){
	 	
	 	$idealo_payment = new idealo_csv_payment();
	 	$this->payment = $idealo_payment->payment;
	 	
	 	foreach ( $this->payment as $pay ){
			
			$payment = array();
			
			$active = 'idealo_' . $pay [ 'db' ] . '_active';
			$payment [ 'active' ] = $this->getValueIdealoSetting ( $active );
			
			$countries = 'idealo_' . $pay [ 'db' ] . '_countries';
			$payment [ 'country' ] = $this->getValueIdealoSetting ( $countries );
			
			$fix = 'idealo_' . $pay [ 'db' ] . '_fix';
			$payment [ 'fix' ] = $this->getValueIdealoSetting ( $fix );
			
			$percent = 'idealo_' . $pay [ 'db' ] . '_percent';
			$payment [ 'percent' ] = $this->getValueIdealoSetting ( $percent );
			
			$shipping = 'idealo_' . $pay [ 'db' ] . '_shipping';
			$payment [ 'shipping' ] = $this->getValueIdealoSetting ( $shipping );

			
			$payment [ 'title' ] = $pay [ 'title' ];
			$payment [ 'db' ] = $pay [ 'db' ];
			
			$this->payment [ $pay [ 'db' ] ] = $payment;	
			
		}
		
	 }

	
	public function getShipping(){
		
		$idealo_shipping = new idealo_csv_shipping();
		$this->shipping = $idealo_shipping->shipping;
		
		foreach ( $this->shipping as $ship ){
			
			$shipping = array();
     		
     		$active = 'idealo_' . $ship [ 'country' ] . '_active';
			$shipping [ 'active' ] = $this->getValueIdealoSetting( $active );
			
			$costs = 'idealo_' . $ship [ 'country' ] . '_costs';
     		$shipping [ 'costs' ] = $this->getValueIdealoSetting( $costs );
     
     		$free = 'idealo_' . $ship [ 'country' ] . '_free';
     		$shipping [ 'free' ] = $this->getValueIdealoSetting( $free );
			
			$type = 'idealo_' . $ship [ 'country' ] . '_type';
     		$shipping [ 'type' ] = $this->getValueIdealoSetting( $type );
     		
			$shipping [ 'country' ] = $ship [ 'country' ];
			
			$this->shipping	[ $ship [ 'country' ] ] = $shipping;
			
		}
		
	}


	
	 public function getValue ( $value ){
	 	
	 	$result = xtc_db_query ( "	SELECT `configuration_value`
									FROM `configuration`
									WHERE `configuration_key` LIKE 'MODULE_IDEALO_CSV_" . $value . "';" );
		$result = xtc_db_fetch_array ( $result );
		
		return $result [ 'configuration_value' ];
		
	 }

 
	
	 public function getUrls(){
	 	
	 	$dir = dirname ( __FILE__ );

	 	$dir = substr ( $dir, 0, -6 );
	 		 	
	 	$url = fopen ( $dir . "link.ido", "r" ); 	
     	$urls =  fgets ( $url );
     	
     	$urls = explode ( '|', $urls );
     	$this->shop_url = $urls [0];
     	$this->image_url = $urls [1];
     	
   	 }

	
	
	public function checkCampaign(){
		
		$campaign_query = xtc_db_query ( "	SELECT `configuration_value` 
											FROM `" . TABLE_CONFIGURATION . "` 
											WHERE `configuration_key` = 'MODULE_IDEALO_CSV_CAMPAIGN' 
											LIMIT 1" );
		$campaign_db = xtc_db_fetch_array ( $campaign_query );
				
		if ( $campaign_db [ 'configuration_value' ] != '0' ){
			
			$this->campaignSet = true;
			
		}
		
	}
	
	
	
	public function getShippingcomment(){
		
		return $this->shippingcomment;
		
	}
	
	
	
	 public function shippingcomment(){
	 	
	 	$shipping_input_query = xtc_db_query ( "SELECT `configuration_value` 
	 											FROM `" . TABLE_CONFIGURATION . "` 
	 											WHERE `configuration_key` = 'MODULE_IDEALO_CSV_SHIPPINGCOMMENT' 
	 											LIMIT 1" );
		$shipping_comment_db = xtc_db_fetch_array ( $shipping_input_query );
				
		$this->shippingcomment = $shipping_comment_db [ 'configuration_value' ];
		
	}

	
	
	 public function openCSVFile( $schema ){
      $fp = fopen ( DIR_FS_DOCUMENT_ROOT . 'export/' . IDEALO_FILENAME, "w+" );
      fputs ( $fp, $schema );
      fclose ( $fp ); 		

	  if( isset ( $_POST [ 'export' ] ) && $_POST [ 'export' ] == 'yes' ) {
            $extension = substr ( IDEALO_FILENAME, -3 );
            $fp = fopen ( DIR_FS_DOCUMENT_ROOT . 'export/' . IDEALO_FILENAME, "rb" );
            $buffer = fread ( $fp, filesize ( DIR_FS_DOCUMENT_ROOT . 'export/' . IDEALO_FILENAME ) );
            fclose ( $fp );

            header ( 'Content-type: application/x-octet-stream' );
            header ( 'Content-disposition: attachment; filename=' . IDEALO_FILENAME );
            echo $buffer;
            
            exit;
                 
	  }
	 	
	 	
	 }
	
	
	
	 public function getArtikelID(){
	 	
	 	$artikel_array  = array();
	 		 	
	 	 $artikel = xtc_db_query("SELECT `products_id` FROM `products`;");
	 	 
	 	 while($products = xtc_db_fetch_array($artikel)){
	 	 	
	 	 	$artikel_array [] = $products [ 'products_id' ];
	 	 	
	 	 }
	 		 	 
	 	 return $artikel_array;
	 	 
	 }
	
	
	
	
	 public function exportArticle(){
	 	
	 	$artikel = $this->getArtikelID();    	
	    	
    	foreach ( $artikel as $art ){
    		$schema .= $this->getCSVValues ( $art, SEPARATOR,  QUOTECHAR );

    	}
	 	
	 	return $schema;
	 	
	 }

	
	public function createHeader(){
		
		$schema =  QUOTECHAR . ARTICLE_ID . QUOTECHAR . SEPARATOR .
					   QUOTECHAR . BRAND . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . PRODUCT_NAME . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . CATEGORIE . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . DESCRIPTION_SHORT . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . DESCRIPTION_SHORT_LONG . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . IMAGE . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . DEEPLINK . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . PRICE . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . EAN . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . DELIVERY . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . BASEPRICE . QUOTECHAR . SEPARATOR .
	        		   QUOTECHAR . WEIGHT . QUOTECHAR . SEPARATOR . 
	        		   QUOTECHAR . CSV_SHIPPINGCOMMENT . QUOTECHAR . SEPARATOR;
	        		       
	        foreach ( $this->shipping as $shipping ){
	        	
	        	if ( $shipping [ 'active' ] == '1' ){
	        		
	        		foreach ( $this->payment as $payment ){
	        		
	        			if ( $payment [ 'active' ] == '1' ){
	        				
	        				$schema .=  QUOTECHAR . $payment [ 'title' ] . '_' . $shipping [ 'country' ] . QUOTECHAR . SEPARATOR;
	        				
	        			}
	        		
	        		}
	        		
	        	}
	        	
	        }
	        
	        $schema .= "\n";
	        
	        
	        $schema .= VERSION_TEXT_01 . VERSION_TEXT_02 . VERSION_TEXT_03 . VERSION_TEXT_04 . "\n";
	        
	        return $schema;
		
	}


	
	private function isIn( $value, $array ){
		
		$array = explode ( ';', $array );
		
		foreach ( $array as $a ){
			
			if ( $a == $value ){
				 
				return true;
				
			}
			
		}
		
		return false;
		
	}


	
	private function filter( $id, $brand ){
		
		if ( IDEALO_CSV_BRAND_FILTER_VALUE != '' ){
			
			$isIn = $this->isIn ( $brand, IDEALO_CSV_BRAND_FILTER_VALUE );
			
			if ( IDEALO_CSV_BRAND_EXPORT == 'export' ){
				
				if ( $isIn === true ){
					
					return true;
					
				}else{
					
					return false;
					
				}
				
			}
					
			if ( IDEALO_CSV_BRAND_EXPORT == 'filter' ){
				
				if ( $isIn === true ){
					
					return false;
					
				}
				
			}
			
		}
		
		if ( IDEALO_CSV_ARTICLE_FILTER_VALUE != '' ){

			$isIn = $this->isIn ( $id, IDEALO_CSV_ARTICLE_FILTER_VALUE );
			if ( IDEALO_CSV_ARTICLE_EXPORT == 'export' ){

				if ( $isIn === true ){
					
					return true;
					
				}else{
					
					return false;
					
				}
				
			}
					
			if ( IDEALO_CSV_ARTICLE_EXPORT == 'filter' ){
				
				if ( $isIn === true ){
					
					return false;
					
				}
				
			}
			
		}
		
		return true;
		
	}


	
	 public function filterCat( $cat ){
	 	
	 	if ( IDEALO_CSV_CAT_FILTER_VALUE != '' ){
	 		
	 		$cat_filter = explode ( ';', IDEALO_CSV_CAT_FILTER_VALUE );
	 		
	 		foreach ( $cat_filter as $ca ){
	 			
	 			if ( strpos ( $cat, $ca ) !== false ){
	 				
	 				if ( IDEALO_CSV_CAT_EXPORT == 'export' ){
	 					
	 					return true;
	 						
	 				}else{
	 					
	 					return false;
	 					
	 				}
	 				
	 				if ( IDEALO_CSV_CAT_EXPORT == 'filter' ){
	 					
	 					return false;
	 						
	 				}
	 				
	 			}
	 			
	 		}	
	 					
		}
		
		if ( IDEALO_CSV_CAT_FILTER_VALUE != '' && IDEALO_CSV_CAT_EXPORT == 'export' ){
			
			return false;
				
		}
		
		return true;
			
	 }

	 
	
	public function getArticle ( $id ){
		
		 $export_query = xtc_db_query( " SELECT
				                             p.products_id,
				                             pd.products_name,
				                             pd.products_description,pd.products_short_description,
				                             p.products_model,p.products_ean,
				                             p.products_image,
				                             p.products_price,
				                             p.products_status,
				                             p.products_shippingtime,
				                             p.products_tax_class_id,
				                             p.products_weight,
				                             m.manufacturers_name,
				                             p.products_vpe_value,
				                             p.products_vpe_status,
				                             p.products_vpe
				                         FROM
				                             " . TABLE_PRODUCTS . " p LEFT JOIN
				                             " . TABLE_MANUFACTURERS . " m
				                           ON p.manufacturers_id = m.manufacturers_id LEFT JOIN
				                             " . TABLE_PRODUCTS_DESCRIPTION . " pd
				                           ON p.products_id = pd.products_id AND
				                            pd.language_id = '" . $_SESSION [ 'languages_id' ] . "' LEFT JOIN
				                             " . TABLE_SPECIALS . " s
				                           ON p.products_id = s.products_id
				                         WHERE
				                         	p.products_id = " . $id . "	  
				                         ORDER BY
				                            p.products_date_added DESC,
				                            pd.products_name" );
	                            
		return xtc_db_fetch_array ( $export_query );
	                            
	}


	public function getCSVValues ( $id, $separator,  $quotarchar ){
		
		$products = $this->getArticle ( $id );

		$schema = '';
			
		$products_price = $this->getPrice ( $products [ 'products_tax_class_id' ], $products [ 'products_price' ], $id );
        $categorie_query = xtc_db_query("	SELECT
                                            categories_id
                                            FROM " . TABLE_PRODUCTS_TO_CATEGORIES . "
                                            WHERE products_id = '" . $products [ 'products_id' ] . "'
                                            ORDER BY categories_id DESC;" );

         while ( $categorie_data = xtc_db_fetch_array ( $categorie_query ) ) {
         	
                $categories = $categorie_data [ 'categories_id' ];
                
         }
         
		$cat = $this->buildCAT ( $categories );
		
			
		if( $products [ 'products_status' ] == 1 && 
			$products_price > 0.00 && 
			$this->filter ( $id, $products[ 'manufacturers_name' ] ) === true && 
			$this->filterCat ( $cat ) === true){
						
			$schema .= $quotarchar . $id . $quotarchar . $separator;

           

      		$products_description = $this->cleanText ( $products [ 'products_description' ], 1000 );

            $products_short_description = $this->cleanText ( $products[ 'products_short_description' ] , 255 );

			

			if ( $products [ 'products_image' ] != '' ){
				
			    $image =  $this->shop_url . $this->image_url . $products [ 'products_image' ];
			    
			}else{
				
			    $image = '';
			    
			}
			
			$price = number_format ( $products_price, 2, '.', '' );

			$language = xtc_db_query("SELECT `code`
									  FROM `languages`
									  WHERE `languages_id` = " . $_SESSION [ 'languages_id' ] . ";" );
	 			
			$language = xtc_db_fetch_array ( $language );
			
			$url = $this->shop_url . DIR_WS_CATALOG . 'product_info.php?' . xtc_product_link ( $products [ 'products_id' ], $products [ 'products_name' ] );

			if ( $this->campaignSet === true ){
				
				$url .= IDEALO_CAMPAIGN;
				
			}


			$schema .=	$quotarchar . $this->cleanText ( $products[ 'manufacturers_name' ], 100 ) . $quotarchar . $separator .
						$quotarchar . $this->cleanText ( $products [ 'products_name' ], 200 ) . $quotarchar . $separator .
						$quotarchar . $this->cleanText ( $cat, 100 ) . $quotarchar . $separator .
						$quotarchar . $products_short_description . $quotarchar . $separator .
						$quotarchar . $products_description . $quotarchar . $separator .
						$quotarchar . $image . $quotarchar . $separator .
						$quotarchar . $url . $quotarchar . $separator .
						$quotarchar . $price . $quotarchar . $separator .
						$quotarchar . $products [ 'products_ean' ] . $quotarchar . $separator .
						$quotarchar . $this->getShippingTime ( $products [ 'products_shippingtime' ], $_SESSION [ 'languages_id' ] ) . $quotarchar . $separator;
		
			if ( $products [ 'products_vpe_status' ] == '1'  && ( float ) $products [ 'products_vpe_value' ] > 0 ){
				
				$vpe = $this->getVPE ( $products [ 'products_vpe' ],  $_SESSION [ 'languages_id' ] );	

				$schema .=	$quotarchar . number_format ( $price / $products [ 'products_vpe_value' ], 2, '.', '' ) . ' EUR / ' . $vpe  . $quotarchar . $separator;
													
			}else{
				
				$schema .= $quotarchar . ''. $quotarchar . $separator;
				
			}
			if ( empty ( $products [ 'products_weight' ] ) ){
				
				$schema .= $quotarchar . 'keine Angabe' . $quotarchar . $separator;
				
			}else{
				
				$schema .= $quotarchar . $products [ 'products_weight' ] . $quotarchar . $separator;
				
			}
			
			$schema .= $quotarchar . $this->shippingcomment . $quotarchar . $separator;
						
			foreach ( $this->shipping as $ship ){
				if ( $ship [ 'active' ] == '1' ){
					
					$costs = $this->getShippingCosts ( $price, $products [ 'products_weight' ], $ship );
					
				}
				
				foreach ( $this->payment as $payment ){
					
					if ( $payment [ 'active' ] == '1' ){
						
						$schema .= $quotarchar . $this->getPaymentCosts ( $payment, $ship [ 'country' ], $price, $costs ) . $quotarchar . $separator;
														
					}
					
				}
				
			}
			
			$schema .= "\n";
		
		}else{
			
			$schema = '';
			
		}
		
	    return $schema;   
	        
    }
	 
	 
	  
    public function getPaymentCosts ( $payment, $country, $price, $shipping ){
		
		$payment_coutry = 'DE';
		
		if ( $payment [ 'country' ] == '2' ){
			
			$payment_coutry = 'DE';
			
		}
		
		if ( $payment [ 'country' ] == '3' ){
			
			$payment_coutry = 'DE/AT';
			
		}	
															 
		$costs = $shipping;
		if ( $payment [ 'fix' ] != '' ){
			
			$costs = $costs + $payment [ 'fix' ];
			
		}
		
		if ( $payment [ 'percent' ] != '' ){
			
			if ( $payment [ 'shipping' ] == '1' ){
				
				$costs = $costs + ( ( $price + $costs ) * $payment [ 'percent' ] / 100 );
				
			}else{
				
				$costs = $costs + ( $price * $payment [ 'percent' ] / 100 );
				
			}
			
		}
		
		$return = '';
		
		if ( strpos ( $payment_coutry, $country ) !== false ){
			
			$return = number_format ( $costs, 2, '.', '' );
			
		}
		
		return number_format ( $shipping, 2, '.', '' );
		
    }
    
    
	 
	 public function getShippingCosts ( $price, $weight, $ship ){
	 	if ( $ship [ 'free' ] != '' ){
	 		
	 		if ( ( float ) $price >= ( float ) $ship [ 'free' ] ){
	 			
	 			return 0;
	 			
	 		}
	 		
	 	}
	 	if ( $ship [ 'type' ] == '3' ){
	 		
	 		return $ship [ 'costs' ];
	 		
	 	}

	 	$costs = explode ( ';', $ship [ 'costs' ] );
	 	$value = '';
	 	
	 	if ( $ship [ 'type' ] == '1' ){
	 		
	 		$value = $weight;
	 		
	 	}else{
	 		
	 		$value = $price;
	 		
	 	}	 	
	 	
	 	for ( $i = 0; $i < count ( $costs ); $i++ ){
	 		
	 		$co = explode ( ':', $costs [ $i ] );
	 		
	 		if ( ( count ( $costs) - 1 ) == $i ){
	 			
	 			return $co [1];
	 			
	 		}
	 		
	 		if ( ( float ) $value <= ( float ) $co [0] ){
	 			
	 			return $co [1];
	 			
	 		}
	 		
	 	} 
	 	
	 }
	 
	 
	  public function getPrice( $tax, $price, $id ){
	  	
	  	$value = xtc_db_query ( " SELECT `tax_rate`
								  FROM `tax_rates`
								  WHERE `tax_class_id` = " . $tax . " 
								  		AND `tax_zone_id` = 5;" );
	 	
	 	$value = xtc_db_fetch_array ( $value );
	 	
	 	$value = $value [ 'tax_rate' ];
	 	
	 	$special = xtc_db_query ( "	SELECT	`specials_new_products_price`
	                                FROM `specials`
	                                WHERE `products_id` = " . $id . " 
	                                	  AND `status` = 1;" );
                                            
        $special = xtc_db_fetch_array ( $special );
            
        if ( !empty ( $special ) ){
        	
           	$price = $special [ 'specials_new_products_price' ];
           	
        }
	 	
	 	$price = $price * ( 1 + $value / 100 );
	 	
	 	return ( float ) $price; 
	 
	  }
	 
	 
	 
	  public function getShippingTime( $id, $la_id ){
	  	$value = xtc_db_query ( " SELECT `shipping_status_name`
								  FROM `shipping_status`
								  WHERE `shipping_status_id` = " . $id . " 
								  		AND `language_id` = " . $la_id . ";" );
	 	
	 	$value = xtc_db_fetch_array ( $value );
	 	
	 	return $value [ 'shipping_status_name' ];
	 	
	  }	
	
	
	
	 public function getVPE( $product_vpe, $language = '1' ){

	 	$vpe = xtc_db_query ( " SELECT `products_vpe_name` 
	 							FROM `products_vpe` 
	 							WHERE `products_vpe_id` = " . $product_vpe . " 
	 								  AND `language_id` = " . $language . ";" );	
	 	$vpe = xtc_db_fetch_array ( $vpe );
	 	
		return $vpe [ 'products_vpe_name' ];
	 	
	 }
	
	
   private function buildCAT ( $catID ) {
		if ( isset ( $this->CAT [ $catID ] ) ){
			
		 return  $this->CAT [ $catID ];
		 
		}else{
			
		   $cat = array();
		   
		   $tmpID=$catID;

		   while ( $this->getParent ( $catID ) != 0 || $catID != 0 ){
		   	
		        $cat_select = xtc_db_query ( " 	SELECT `categories_name` 
		        								FROM `".TABLE_CATEGORIES_DESCRIPTION."` 
		        								WHERE `categories_id` = '" . $catID . "' 
		        									  AND `language_id` = '" . $_SESSION [ 'languages_id' ] . "'" );
		  	    $cat_data = xtc_db_fetch_array ( $cat_select );
		  	    
		    	$catID = $this->getParent ( $catID );
		    	
		    	$cat[] = $this->cleanText ( $cat_data [ 'categories_name' ], 100 );
		    	
		   }

		   $catStr = '';
		   
		   for ( $i = count ( $cat ); $i > 0;$i-- ){
		   	
		      $catStr .= $cat [ $i - 1 ] . ' -> ';
		      
		   }
		   
		   $this->CAT [ $tmpID ] = substr ( $catStr, 0, -4 );

		  return $this->CAT [ $tmpID ];
		  
		}
		
    }
    
    
    
   private function getParent( $catID ) {
   	
      if ( isset ( $this->PARENT [ $catID ]  ) ) {
      	
       return $this->PARENT [ $catID ];
       
      } else {
      	
       $parent_query = xtc_db_query ( " SELECT `parent_id` 
       									FROM `" . TABLE_CATEGORIES . "` 
       									WHERE `categories_id` = '" . $catID . "'" );
       $parent_data = xtc_db_fetch_array ( $parent_query );
       
       $this->PARENT [ $catID ] = $parent_data [ 'parent_id' ];
       
       return  $parent_data [ 'parent_id' ];
       
      }
      
    }
    
    
}
